import torch
import onnx
import onnxruntime as ort
import MetaTrader5 as mt5
import pandas as pd
import numpy as np

# Load the ONNX model
onnx_model = onnx.load("data_processing_pipeline.onnx")
onnx.checker.check_model(onnx_model)

# Initialize MT5 and fetch new data
if not mt5.initialize():
    print("Initialize failed")
    mt5.shutdown()

symbol = "EURUSD"
timeframe = mt5.TIMEFRAME_M15
rates = mt5.copy_rates_from_pos(symbol, timeframe, 0, 160)
mt5.shutdown()

# Convert the new data to a DataFrame
data = pd.DataFrame(rates)[['time', 'open', 'high', 'low', 'close']]
data_tensor = torch.tensor(data.values, dtype=torch.float32)

# Prepare the input for ONNX
input_data = data_tensor.numpy()

# Run the ONNX model
ort_session = ort.InferenceSession("data_processing_pipeline.onnx")
input_name = ort_session.get_inputs()[0].name
output_name = ort_session.get_outputs()[0].name

processed_data = ort_session.run([output_name], {input_name: input_data})[0]

# Convert the output back to DataFrame for easy viewing
processed_df = pd.DataFrame(processed_data, columns=['time_token', 'norm_open', 'norm_high', 'norm_low', 'norm_close'])

print('Processed Data')
print(processed_df)
